## Palm OS Generic 68K PNO Makefile Engine for Palm OS Developer Suite v1.1.0
#
# Last edit: 11/10/04
#
# This makefile engine is capable of compiling 68K PNO 
# static libraries for the Palm OS.
#
# This makefile engine assumes that the following variables are 
# set outside of this makefile by a referencing master makefile
# (see a master makefile generated by a Palm OS Developer 
# Suite wizard for detailed explanation of each variable):
#
#	SOURCES
#	DEBUG_OR_RELEASE 
#	TARGET_PLATFORM
#	OPTIMIZE_LEVEL 
#	SIM_WARNING_LEVEL  
#	PNO_WARNING_LEVEL  
#	SIM_WARNING_AS_ERROR
#	PNO_WARNING_AS_ERROR
#	SIM_VERBOSE
#	PNO_VERBOSE
#	ENABLE_ASSERTIONS
#	LOCAL_PNO_INCLUDE_PATHS 
#	LOCAL_PNO_SIM_INCLUDE_PATHS
#	SYSTEM_PNO_INCLUDE_PATHS 
#	SYSTEM_PNO_SIM_INCLUDE_PATHS
#	PNO_PRE_INCLUDE_PATHS
#	PNO_SIM_PRE_INCLUDE_PATHS
#	PNO_DEFINES 
#	PNO_SIM_DEFINES 
#	PNO_UNDEFINES 
#	PNO_SIM_UNDEFINES 
#	ADDITIONAL_PNO_COMPILER_FLAGS
#	ADDITIONAL_PNO_SIM_COMPILER_FLAGS
#	ADDITIONAL_AR_FLAGS
#	ADDITIONAL_SIM_AR_FLAGS
#	DEBUG_DEVICE_OUTPUT_DIR
#	RELEASE_DEVICE_OUTPUT_DIR
#	DEBUG_SIMULATOR_OUTPUT_DIR
#	RELEASE_SIMULATOR_OUTPUT_DIR
#
# Additionally, the user of this makefile engine may obtain the 
# dynamic values for:
#	SDK_LOCATION
#	SDK_VERSION
#	TOOLS_DIR 
# by doing an optional include of a makefile segment that is 
# generated during the Palm OS Developer Suite standard make build.
# The makefile line to accomplish this is:
#	-include auto-generated.mk
# All master makefiles generated by Palm OS Developer Suite
# wizards include this line already to pick up and use these
# dynamic definitions.
#
# All variable values may be overridden by editing the make command
# for the project (Project->Properties->C/C++ Make Project->Make Builder,
# Build Command field).
#

###############################################################################
# Defaults

ifeq ($(DEBUG_DEVICE_OUTPUT_DIR), )
	DEBUG_DEVICE_OUTPUT_DIR = DebugDevice
endif

ifeq ($(RELEASE_DEVICE_OUTPUT_DIR), )
	RELEASE_DEVICE_OUTPUT_DIR = ReleaseDevice
endif

ifeq ($(DEBUG_SIMULATOR_OUTPUT_DIR), )
	DEBUG_SIMULATOR_OUTPUT_DIR = DebugSim
endif

ifeq ($(RELEASE_SIMULATOR_OUTPUT_DIR), )
	RELEASE_SIMULATOR_OUTPUT_DIR = ReleaseSim
endif

ifeq ($(LIB_NAME), )
	LIB_NAME = Start.a
endif

ifeq ($(SIM_LIB_NAME), )
	SIM_LIB_NAME = Start.lib
endif

ifeq ($(SDK_VERSION), )
	SDK_VERSION = sdk-5r4
endif

###############################################################################
# Determine output directories

# project type lib
ifeq ($(DEBUG_OR_RELEASE), Debug)

	# project type lib, debug, device
	SIM_OBJ_DIR = $(DEBUG_SIMULATOR_OUTPUT_DIR)
	ARM_OBJ_DIR = $(DEBUG_DEVICE_OUTPUT_DIR)
	
else

	# project type lib, release, device
	SIM_OBJ_DIR = $(RELEASE_SIMULATOR_OUTPUT_DIR)
	ARM_OBJ_DIR = $(RELEASE_DEVICE_OUTPUT_DIR)

endif

###############################################################################
# Make target determination

ifeq ($(TARGET_PLATFORM), Device)
	PROJECT_MAKE_TARGET = static_lib_device
	OBJ_DIR = $(ARM_OBJ_DIR)
else
	PROJECT_MAKE_TARGET = static_lib_simulator
	OBJ_DIR = $(SIM_OBJ_DIR)
endif

###############################################################################

STATIC_LIB_TARGET := $(OBJ_DIR)/$(LIB_NAME)
SIM_STATIC_LIB_TARGET := $(OBJ_DIR)/$(SIM_LIB_NAME)


# Compiler Settings ... this is a makefile for Palm OS 68K and PNO
# so the compilers used are as follows:
# PNO compiler is pacc
# PNO "simlet" compiler is gcc

# Compiler settings... compiler + optimizations + debug
ARM_CC = "$(TOOLS_DIR)pacc"
ARM_CFLAGS += -pno -nocrt -D__PALMOS__=0x05000000
ARM_DEPFLAGS = -M1

SIM_CC = gcc
SIM_CFLAGS += -D__PALMOS__=0x05000000
DEPFLAGS = -MM -MG -P -w 

# Optimization settings
ifeq ($(OPTIMIZE_LEVEL), FULL)
	OPTIMIZER_FLAG	= -O3
else
ifeq ($(OPTIMIZE_LEVEL), SOME)
	OPTIMIZER_FLAG	= -O1
else
ifeq ($(OPTIMIZE_LEVEL), NONE)
	OPTIMIZER_FLAG	= -O0
else
# default to FULL
	OPTIMIZER_FLAG	= -O3
endif
endif
endif
	
# Debug settings (can override optimize settings)
ifeq ($(DEBUG_OR_RELEASE), Debug)
	DEBUG_FLAG += -g
	OPTIMIZER_FLAG = -O0
endif	

ARM_CFLAGS += $(OPTIMIZER_FLAG) $(DEBUG_FLAG)
SIM_CFLAGS += $(OPTIMIZER_FLAG) $(DEBUG_FLAG)

# Warning level for PNO device target
ifeq ($(PNO_WARNING_LEVEL), ALL)
	ARM_CFLAGS += -W4
else
ifeq ($(PNO_WARNING_LEVEL), SOME)
	ARM_CFLAGS += -W2
else
ifeq ($(PNO_WARNING_LEVEL), NONE)
	ARM_CFLAGS += -W0
endif
endif
endif

# Warning level for PNO simulator target compilation
ifeq ($(SIM_WARNING_LEVEL), ALL)
	SIM_CFLAGS += -Wall 
else
ifeq ($(SIM_WARNING_LEVEL), NONE)
	SIM_CFLAGS += -w
endif
endif

# Warnings as errors for PNO device builds
ifeq ($(PNO_WARNING_AS_ERROR), TRUE)
	ARM_CFLAGS += -Werror
endif

# Warnings as errors for PNO simulator builds
ifeq ($(SIM_WARNING_AS_ERROR), TRUE)
	SIM_CFLAGS += -Werror
endif

# Verbose output for PNO device builds
ifeq ($(PNO_VERBOSE), TRUE)
	ARM_CFLAGS += -v
endif

# Verbose output for PNO simulator builds
ifeq ($(SIM_VERBOSE), TRUE)
	SIM_CFLAGS += -v
endif

# Assertion handling support
ifeq ($(ENABLE_ASSERTIONS), TRUE)
	ARM_CFLAGS += -UNDEBUG
else
	ARM_CFLAGS += -DNDEBUG=1
endif

# Skip multichar constant warnings
SIM_CFLAGS += -Wno-multichar

# Librarian settings
AR=palib
ARFLAGS= -ra
SIM_AR=ar
SIM_ARFLAGS = -rc

# function for converting PNO sources to object file names in $(ARM_OBJ_DIR)
define SOURCE_LIST_TO_ARM_OBJS
	$(addprefix $(ARM_OBJ_DIR)/, $(addsuffix .o, $(foreach file, $(SOURCES), \
	$(basename $(notdir $(file))))))
endef

# function for converting PNO sources to dependency file names in $(ARM_OBJ_DIR)
define SOURCE_LIST_TO_ARM_DEPS
	$(addprefix $(ARM_OBJ_DIR)/, $(addsuffix .d, $(foreach file, $(PNO_SOURCES), \
	$(basename $(notdir $(file))))))
endef

# function for converting PNO sources to object file names in $(SIM_OBJ_DIR)
define SOURCE_LIST_TO_SIM_OBJS
	$(addprefix $(SIM_OBJ_DIR)/, $(addsuffix .o, $(foreach file, $(SOURCES), \
	$(basename $(notdir $(file))))))
endef

# function for converting PNO sources to dependency file names in $(SIM_OBJ_DIR)
define SOURCE_LIST_TO_SIM_DEPS
	$(addprefix $(SIM_OBJ_DIR)/, $(addsuffix .d, $(foreach file, $(PNO_SOURCES), \
	$(basename $(notdir $(file))))))
endef


ARM_OBJS = $(SOURCE_LIST_TO_ARM_OBJS)
SIM_OBJS = $(SOURCE_LIST_TO_SIM_OBJS)

ifeq ($(TARGET_PLATFORM), Device)
	DEPS = $(SOURCE_LIST_TO_ARM_DEPS)
else
	DEPS = $(SOURCE_LIST_TO_SIM_DEPS)
endif


PNO_SOURCE_PATHS += $(sort $(foreach file, $(SOURCES), $(dir $(file))))


VPATH :=
VPATH += $(addprefix :, $(subst  ,:, $(filter-out $($(subst, :, ,$(VPATH))), $(SOURCE_PATHS) $(RESOURCE_PATHS) $(PNO_SOURCE_PATHS))))

PNO_SYSTEM_INCLUDES = $(SYSTEM_PNO_INCLUDE_PATHS) -I"$(SDK_LOCATION)include" -I"$(SDK_LOCATION)include/Core/System"
PNO_INCLUDES = $(LOCAL_PNO_INCLUDE_PATHS) $(foreach path, $(SOURCE_PATHS), $(addprefix -I, $(path))) $(PNO_SYSTEM_INCLUDES) $(PNO_PRE_INCLUDE_PATHS)

PNO_SIM_SYSTEM_INCLUDES = $(SYSTEM_PNO_SIM_INCLUDE_PATHS) -I"$(SDK_LOCATION)include" -I"$(SDK_LOCATION)include/Core/System"
PNO_SIM_INCLUDES = $(LOCAL_PNO_SIM_INCLUDE_PATHS) $(foreach path, $(SOURCE_PATHS), $(addprefix -I, $(path))) $(PNO_SIM_SYSTEM_INCLUDES) $(PNO_SIM_PRE_INCLUDE_PATHS)

# Now add additional settings specified by user
SIM_CFLAGS += $(foreach define, $(PNO_SIM_DEFINES), $(addprefix -D, $(define)))
SIM_CFLAGS += $(foreach define, $(PNO_SIM_UNDEFINES), $(addprefix -U, $(define)))
SIM_CFLAGS += $(ADDITIONAL_PNO_SIM_COMPILER_FLAGS)

ARM_CFLAGS += $(foreach define, $(PNO_DEFINES), $(addprefix -D, $(define)))
ARM_CFLAGS += $(foreach define, $(PNO_UNDEFINES), $(addprefix -U, $(define)))
ARM_CFLAGS += $(ADDITIONAL_PNO_COMPILER_FLAGS)

# Specify additional archival flags (for static libraries)
ARFLAGS += $(ADDITIONAL_AR_FLAGS)
SIM_ARFLAGS += $(ADDITIONAL_SIM_AR_FLAGS)


###############################################################################
# Dependency includes

-include $(DEPS)


###############################################################################
# Defaults

#	Eclipse requires an all target to get the work done
all: $(PROJECT_MAKE_TARGET)
	@echo Build complete

#	This rule is only valid for projects created as static library projects.
#	Don't invoke this make target directly; instead change the value of
#	TARGET_PLATFORM to Device in the main makefile
static_lib_device: $(ARM_OBJ_DIR) $(STATIC_LIB_TARGET)

#	This rule is only valid for projects created as static library projects.
#	Don't invoke this make target directly; instead change the value of
#	TARGET_PLATFORM to Simulator in the main makefile
static_lib_simulator: $(SIM_OBJ_DIR) $(SIM_STATIC_LIB_TARGET)


$(ARM_OBJ_DIR): 
ifneq ($(SOURCES), )
	@[ -d $(ARM_OBJ_DIR) ] || mkdir $(ARM_OBJ_DIR) > /dev/null 2>&1
endif
	
$(SIM_OBJ_DIR):
ifneq ($(SOURCES), )
	@[ -d $(SIM_OBJ_DIR) ] || mkdir $(SIM_OBJ_DIR) > /dev/null 2>&1
endif


# ARM C/C++ sources
$(ARM_OBJ_DIR)/%.o : %.c
	@echo
	$(ARM_CC) -c $< $(PNO_INCLUDES) $(ARM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $@ : ' ' > $(@:%.o=%.d) && \
	$(ARM_CC) $< $(ARM_DEPFLAGS) $(PNO_INCLUDES) $(ARM_CFLAGS) | /usr/bin/sed 's/^.*: //' | /usr/bin/sed 's/ /\\\ /g' | /usr/bin/tr '\r\n' ' ' >> $(@:%.o=%.d) && \
	echo -e \\n\\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(ARM_OBJ_DIR)/%.o : %.cpp 
	@echo
	$(ARM_CC) -c $< $(PNO_INCLUDES) $(ARM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $@ : ' ' > $(@:%.o=%.d) && \
	$(ARM_CC) $< $(ARM_DEPFLAGS) $(PNO_INCLUDES) $(ARM_CFLAGS) | /usr/bin/sed 's/^.*: //' | /usr/bin/sed 's/ /\\\ /g' | /usr/bin/tr '\r\n' ' ' >> $(@:%.o=%.d) && \
	echo -e \\n\\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(ARM_OBJ_DIR)/%.o : %.cp 
	@echo
	$(ARM_CC) -c $< $(PNO_INCLUDES) $(ARM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $@ : ' ' > $(@:%.o=%.d) && \
	$(ARM_CC) $< $(ARM_DEPFLAGS) $(PNO_INCLUDES) $(ARM_CFLAGS) | /usr/bin/sed 's/^.*: //' | /usr/bin/sed 's/ /\\\ /g' | /usr/bin/tr '\r\n' ' ' >> $(@:%.o=%.d) && \
	echo -e \\n\\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(ARM_OBJ_DIR)/%.o : %.cc 
	@echo
	$(ARM_CC) -c $< $(PNO_INCLUDES) $(ARM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $@ : ' ' > $(@:%.o=%.d) && \
	$(ARM_CC) $< $(ARM_DEPFLAGS) $(PNO_INCLUDES) $(ARM_CFLAGS) | /usr/bin/sed 's/^.*: //' | /usr/bin/sed 's/ /\\\ /g' | /usr/bin/tr '\r\n' ' ' >> $(@:%.o=%.d) && \
	echo -e \\n\\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(ARM_OBJ_DIR)/%.o : %.C 
	@echo
	$(ARM_CC) -c $< $(PNO_INCLUDES) $(ARM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $@ : ' ' > $(@:%.o=%.d) && \
	$(ARM_CC) $< $(ARM_DEPFLAGS) $(PNO_INCLUDES) $(ARM_CFLAGS) | /usr/bin/sed 's/^.*: //' | /usr/bin/sed 's/ /\\\ /g' | /usr/bin/tr '\r\n' ' ' >> $(@:%.o=%.d) && \
	echo -e \\n\\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(ARM_OBJ_DIR)/%.o : %.CC 
	@echo
	$(ARM_CC) -c $< $(PNO_INCLUDES) $(ARM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $@ : ' ' > $(@:%.o=%.d) && \
	$(ARM_CC) $< $(ARM_DEPFLAGS) $(PNO_INCLUDES) $(ARM_CFLAGS) | /usr/bin/sed 's/^.*: //' | /usr/bin/sed 's/ /\\\ /g' | /usr/bin/tr '\r\n' ' ' >> $(@:%.o=%.d) && \
	echo -e \\n\\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(ARM_OBJ_DIR)/%.o : %.CPP 
	@echo
	$(ARM_CC) -c $< $(PNO_INCLUDES) $(ARM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $@ : ' ' > $(@:%.o=%.d) && \
	$(ARM_CC) $< $(ARM_DEPFLAGS) $(PNO_INCLUDES) $(ARM_CFLAGS) | /usr/bin/sed 's/^.*: //' | /usr/bin/sed 's/ /\\\ /g' | /usr/bin/tr '\r\n' ' ' >> $(@:%.o=%.d) && \
	echo -e \\n\\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	

# Simulator C/C++ sources - use host gcc
$(SIM_OBJ_DIR)/%.o : %.c
	@echo
	$(SIM_CC) -c $< $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(SIM_CC) -c $< $(DEPFLAGS) $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(SIM_OBJ_DIR)/%.o : %.cpp 
	@echo
	$(SIM_CC) -c $< $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(SIM_CC) -c $< $(DEPFLAGS) $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(SIM_OBJ_DIR)/%.o : %.cp
	@echo
	$(SIM_CC) -c $< $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(SIM_CC) -c $< $(DEPFLAGS) $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(SIM_OBJ_DIR)/%.o : %.cc
	@echo
	$(SIM_CC) -c $< $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(SIM_CC) -c $< $(DEPFLAGS) $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(SIM_OBJ_DIR)/%.o : %.C 
	@echo
	$(SIM_CC) -c $< $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(SIM_CC) -c $< $(DEPFLAGS) $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(SIM_OBJ_DIR)/%.o : %.CC 
	@echo
	$(SIM_CC) -c $< $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(SIM_CC) -c $< $(DEPFLAGS) $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)
	
$(SIM_OBJ_DIR)/%.o : %.CPP 
	@echo
	$(SIM_CC) -c $< $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) -o $@
	echo -n $(@:%.o=%.d) $(dir $@) > $(@:%.o=%.d) && \
	$(SIM_CC) -c $< $(DEPFLAGS) $(PNO_SIM_INCLUDES) $(SIM_CFLAGS) >> $(@:%.o=%.d) && \
	echo -e \\n$(@:%.o=%.d) $@ : makefile makefile-engine.mk auto-generated.mk >> $(@:%.o=%.d)


$(STATIC_LIB_TARGET) : $(ARM_OBJS)
	@echo
	@echo "...Linking Static Library: $(STATIC_LIB_TARGET)..."
	$(AR) $(ARFLAGS) $(STATIC_LIB_TARGET) $(ARM_OBJS) 

$(SIM_STATIC_LIB_TARGET) : $(SIM_OBJS)
	@echo
	@echo "...Linking Static Library for Simulator target: $(SIM_STATIC_LIB_TARGET)..."
	$(SIM_AR) $(SIM_ARFLAGS) $(SIM_STATIC_LIB_TARGET) $(SIM_OBJS) 


FORCE:

# Eclipse requires a clean command
# just delete everything in OBJ_DIR and any section files
clean :: FORCE
	-rm -rf $(OBJ_DIR)/*

